/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.controls;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFW;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.controls.ControlsRegister;
import xaero.map.controls.IKeyBindingHelper;
import xaero.map.controls.KeyEvent;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.gui.ScreenBase;
import xaero.map.platform.Services;

public class ControlsHandler {
    private MapProcessor mapProcessor;
    private ArrayList<KeyEvent> keyEvents = new ArrayList();
    private ArrayList<KeyEvent> oldKeyEvents = new ArrayList();

    public ControlsHandler(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    private boolean eventExists(KeyMapping kb) {
        for (KeyEvent o : this.keyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return this.oldEventExists(kb);
    }

    private boolean oldEventExists(KeyMapping kb) {
        for (KeyEvent o : this.oldKeyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return false;
    }

    public static void setKeyState(KeyMapping kb, boolean pressed) {
        if (kb.isDown() != pressed) {
            KeyMapping.set((InputConstants.Key)Services.PLATFORM.getKeyBindingHelper().getBoundKeyOf(kb), (boolean)pressed);
        }
    }

    public static boolean isDown(KeyMapping kb) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        if (keyBindingHelper.getBoundKeyOf(kb).getValue() == -1) {
            return false;
        }
        if (keyBindingHelper.getBoundKeyOf(kb).getType() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().handle(), (int)keyBindingHelper.getBoundKeyOf(kb).getValue()) == 1;
        }
        if (keyBindingHelper.getBoundKeyOf(kb).getType() == InputConstants.Type.KEYSYM) {
            return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)keyBindingHelper.getBoundKeyOf(kb).getValue());
        }
        return false;
    }

    public static boolean isKeyRepeat(KeyMapping kb) {
        return kb != ControlsRegister.keyOpenMap && kb != ControlsRegister.keyOpenSettings && kb != ControlsRegister.keyToggleDimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyDown(KeyMapping kb, boolean tickEnd, boolean isRepeat) {
        Minecraft mc = Minecraft.getInstance();
        if (!tickEnd) {
            if (kb == ControlsRegister.keyOpenMap) {
                mc.setScreen((Screen)new GuiMap(null, null, this.mapProcessor, mc.getCameraEntity()));
            } else if (kb == ControlsRegister.keyOpenSettings) {
                mc.setScreen((Screen)new GuiWorldMapSettings());
            } else if (kb == ControlsRegister.keyQuickConfirm) {
                WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                Object object = mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!mapProcessor.isUIPaused()) {
                        mapProcessor.quickConfirmMultiworld();
                    }
                }
            } else if (kb == ControlsRegister.keyToggleDimension) {
                this.mapProcessor.getMapWorld().toggleDimension(!ScreenBase.hasShiftDown());
                String messageType = this.mapProcessor.getMapWorld().getCustomDimensionId() == null ? "gui.xaero_switched_to_current_dimension" : "gui.xaero_switched_to_dimension";
                ResourceLocation messageDimLoc = this.mapProcessor.getMapWorld().getFutureDimensionId() == null ? null : this.mapProcessor.getMapWorld().getFutureDimensionId().location();
                mc.gui.getChat().addMessage((Component)Component.translatable((String)messageType, (Object[])new Object[]{messageDimLoc.toString()}));
            }
        }
    }

    public void keyUp(KeyMapping kb, boolean tickEnd) {
        if (!tickEnd) {
            // empty if block
        }
    }

    public void handleKeyEvents() {
        KeyEvent ke;
        int i;
        Minecraft mc = Minecraft.getInstance();
        this.onKeyInput(mc);
        for (i = 0; i < this.keyEvents.size(); ++i) {
            ke = this.keyEvents.get(i);
            if (mc.screen == null) {
                this.keyDown(ke.getKb(), ke.isTickEnd(), ke.isRepeat());
            }
            if (!ke.isRepeat()) {
                if (!this.oldEventExists(ke.getKb())) {
                    this.oldKeyEvents.add(ke);
                }
                this.keyEvents.remove(i);
                --i;
                continue;
            }
            if (ControlsHandler.isDown(ke.getKb())) continue;
            this.keyUp(ke.getKb(), ke.isTickEnd());
            this.keyEvents.remove(i);
            --i;
        }
        for (i = 0; i < this.oldKeyEvents.size(); ++i) {
            ke = this.oldKeyEvents.get(i);
            if (ControlsHandler.isDown(ke.getKb())) continue;
            this.keyUp(ke.getKb(), ke.isTickEnd());
            this.oldKeyEvents.remove(i);
            --i;
        }
    }

    public void onKeyInput(Minecraft mc) {
        List<KeyMapping> kbs = WorldMap.controlsRegister.keybindings;
        for (int i = 0; i < kbs.size(); ++i) {
            KeyMapping kb = kbs.get(i);
            try {
                boolean pressed = kb.consumeClick();
                while (kb.consumeClick()) {
                }
                if (mc.screen != null || this.eventExists(kb) || !pressed) continue;
                this.keyEvents.add(new KeyEvent(kb, false, ControlsHandler.isKeyRepeat(kb), true));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

